implementation module id


//	Clean Object I/O library, version 1.1


import StdOverloaded, StdInt, StdBool, StdString
import commondef


idFatalError :: String String -> .x
idFatalError rule error
	= FatalError rule "id" error

 
::	Id										// The Id data type:
	=	CustomId	Int						// Range of Ids generated by programs
	|	CustomRId	Int						// Range of Ids generated by programs for uni-receivers
	|	CustomR2Id	Int						// Range of Ids generated by programs for bi-receivers
	|	SysId		Int						// Range of Ids generated for device instances
	|	SpecialId	Int						// Range of Ids generated for special components
::	RId mess								// The identification of uni-directional receivers:
	=	RId Int
::	R2Id mess resp							// The identification of bi-directional receivers:
	=	R2Id Int


//	Special Ids:

SpecialWindowMenuId			:==	1			// The special id of the WindowMenu
SpecialWindowMenuRadioId	:==	2			// The id of the RadioMenu displaying the open windows
SpecialWindowMenuCascadeId	:==	3			// The id of the Cascade WindowMenu item
SpecialWindowMenuTileHId	:==	4			// The id of the Tile Horizontally WindowMenu item
SpecialWindowMenuTileVId	:==	5			// The id of the Tile Vertically WindowMenu item
SpecialWindowMenuSeparatorId:==	6			// The id of the MenuSeparator item

specialIdName :: !Int -> {#Char}
specialIdName SpecialWindowMenuId			= "WindowMenuId"
specialIdName SpecialWindowMenuRadioId		= "WindowMenuRadioId"
specialIdName SpecialWindowMenuCascadeId	= "SpecialWindowMenuCascadeId"
specialIdName SpecialWindowMenuTileHId		= "SpecialWindowMenuTileHId"
specialIdName SpecialWindowMenuTileVId		= "SpecialWindowMenuTileVId"
specialIdName SpecialWindowMenuSeparatorId	= "WindowMenuSeparatorId"
specialIdName _								= idFatalError "toString (Id)" "undefined special Id."

WindowMenuId			:: Id;		WindowMenuId			= SpecialId SpecialWindowMenuId;
WindowMenuRadioId		:: Id;		WindowMenuRadioId		= SpecialId SpecialWindowMenuRadioId;
WindowMenuCascadeId		:: Id;		WindowMenuCascadeId		= SpecialId SpecialWindowMenuCascadeId;
WindowMenuTileHId		:: Id;		WindowMenuTileHId		= SpecialId SpecialWindowMenuTileHId;
WindowMenuTileVId		:: Id;		WindowMenuTileVId		= SpecialId SpecialWindowMenuTileVId;
WindowMenuSeparatorId	:: Id;		WindowMenuSeparatorId	= SpecialId SpecialWindowMenuSeparatorId;


toId :: !Int -> Id
toId i = CustomId i

toRId :: !Int -> RId mess
toRId i = RId i

toR2Id :: !Int -> R2Id mess resp
toR2Id i = R2Id i

sysId :: !Int -> Id
sysId i = SysId i

fromId :: !Id -> Int
fromId (CustomId   id)		= id
fromId (CustomRId  id)		= id
fromId (CustomR2Id id)		= id
fromId (SysId	   id)		= id
fromId (SpecialId  id)		= id

isSysId :: !Id -> Bool
isSysId (SysId _)			= True
isSysId _					= False

isCustomId :: !Id -> Bool
isCustomId (CustomId _)		= True
isCustomId _				= False

isCustomRId :: !Id -> Bool
isCustomRId (CustomRId _)	= True
isCustomRId _				= False

isCustomR2Id :: !Id -> Bool
isCustomR2Id (CustomR2Id _)	= True
isCustomR2Id _				= False

isSpecialId :: !Id -> Bool
isSpecialId (SpecialId _)	= True
isSpecialId _				= False

instance == Id
where
	(==) :: !Id !Id -> Bool
	(==) (CustomId	 id1)	id	= case id of
									(CustomId	id2)	-> id1==id2
									(CustomRId	id2)	-> id1==id2 // MW++
									(CustomR2Id	id2)	-> id1==id2 // MW++
									_					-> False
	(==) (CustomRId	 id1)	id	= case id of
									(CustomId	id2)	-> id1==id2 // MW++
									(CustomRId	id2)	-> id1==id2
									(CustomR2Id	id2)	-> id1==id2 // MW++
									_					-> False
	(==) (CustomR2Id id1)	id	= case id of
									(CustomId	id2)	-> id1==id2 // MW++
									(CustomRId	id2)	-> id1==id2 // MW++
									(CustomR2Id	id2)	-> id1==id2
									_					-> False
	(==) (SysId		 id1)	id	= case id of
									(SysId		id2)	-> id1==id2
									_					-> False
	(==) (SpecialId  id1)	id	= case id of
									(SpecialId	id2)	-> id1==id2
									_					-> False
	(==) _					_	= False

instance == (RId mess)
where
	(==) :: !(RId mess) !(RId mess) -> Bool
	(==) (RId i) (RId j) = i==j

instance == (R2Id mess resp)
where
	(==) :: !(R2Id mess resp) !(R2Id mess resp) -> Bool
	(==) (R2Id i) (R2Id j) = i==j

RIdtoId :: (RId mess) -> Id
RIdtoId (RId i) = CustomRId i

R2IdtoId :: (R2Id mess resp) -> Id
R2IdtoId (R2Id i) = CustomR2Id i

instance toString Id
where
	toString :: !Id -> {#Char}
	toString (CustomId id)	= "toId "+++toString id
	toString (CustomRId _)	= "RId"
	toString (CustomR2Id _)	= "R2Id"
	toString (SysId _)		= "Id"
	toString (SpecialId id)	= specialIdName id
